/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.registries.RegistryManager;
import org.slf4j.Logger;

public interface RegistryResourceAccess {
    public <E> Collection<ResourceKey<E>> m_183590_(ResourceKey<? extends Registry<E>> var1);

    public <E> Optional<DataResult<ParsedEntry<E>>> m_183313_(DynamicOps<JsonElement> var1, ResourceKey<? extends Registry<E>> var2, ResourceKey<E> var3, Decoder<E> var4);

    public static RegistryResourceAccess m_195881_(final ResourceManager p_195882_) {
        return new RegistryResourceAccess(){
            private static final String f_195889_ = ".json";

            @Override
            public <E> Collection<ResourceKey<E>> m_183590_(ResourceKey<? extends Registry<E>> p_195905_) {
                String s = 1.m_195909_(p_195905_);
                HashSet set = new HashSet();
                p_195882_.m_6540_(s, p_195898_ -> p_195898_.endsWith(f_195889_)).forEach(p_195903_ -> {
                    String s1 = p_195903_.m_135815_();
                    String s2 = s1.substring(s.length() + 1, s1.length() - f_195889_.length());
                    set.add(ResourceKey.m_135785_(p_195905_, new ResourceLocation(p_195903_.m_135827_(), s2)));
                });
                return set;
            }

            @Override
            public <E> Optional<DataResult<ParsedEntry<E>>> m_183313_(DynamicOps<JsonElement> p_195893_, ResourceKey<? extends Registry<E>> p_195894_, ResourceKey<E> p_195895_, Decoder<E> p_195896_) {
                ResourceLocation resourcelocation = 1.m_195906_(p_195894_, p_195895_);
                if (!p_195882_.m_7165_(resourcelocation)) {
                    return Optional.empty();
                }
                try {
                    Optional<DataResult<ParsedEntry<E>>> optional;
                    try (Resource resource = p_195882_.m_142591_(resourcelocation);
                         InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);){
                        JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                        if (jsonelement != null) {
                            jsonelement.getAsJsonObject().addProperty("forge:registry_name", p_195895_.m_135782_().toString());
                        }
                        optional = Optional.of(p_195896_.parse(p_195893_, (Object)jsonelement).map(ParsedEntry::m_195956_));
                    }
                    return optional;
                }
                catch (JsonIOException | JsonSyntaxException | IOException ioexception) {
                    return Optional.of(DataResult.error((String)("Failed to parse " + resourcelocation + " file: " + ioexception.getMessage())));
                }
            }

            private static String m_195909_(ResourceKey<? extends Registry<?>> p_195910_) {
                if (RegistryManager.FROZEN.getRegistry(p_195910_.m_135782_()) != null && !p_195910_.m_135782_().m_135827_().equals("minecraft")) {
                    return p_195910_.m_135782_().m_135827_() + "/" + p_195910_.m_135782_().m_135815_();
                }
                return p_195910_.m_135782_().m_135815_();
            }

            private static <E> ResourceLocation m_195906_(ResourceKey<? extends Registry<E>> p_195907_, ResourceKey<E> p_195908_) {
                return new ResourceLocation(p_195908_.m_135782_().m_135827_(), 1.m_195909_(p_195907_) + "/" + p_195908_.m_135782_().m_135815_() + f_195889_);
            }

            public String toString() {
                return "ResourceAccess[" + p_195882_ + "]";
            }
        };
    }

    public record ParsedEntry<E>(E f_195950_, OptionalInt f_195951_) {
        public static <E> ParsedEntry<E> m_195956_(E p_195957_) {
            return new ParsedEntry<E>(p_195957_, OptionalInt.empty());
        }

        public static <E> ParsedEntry<E> m_195958_(E p_195959_, int p_195960_) {
            return new ParsedEntry<E>(p_195959_, OptionalInt.of(p_195960_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "f_195950_", "f_195951_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "f_195950_", "f_195951_"}, this);
        }

        @Override
        public final boolean equals(Object p_195963_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ParsedEntry.class, "value;fixedId", "f_195950_", "f_195951_"}, this, p_195963_);
        }
    }

    public static final class InMemoryStorage
    implements RegistryResourceAccess {
        private static final Logger f_195912_ = LogUtils.getLogger();
        private final Map<ResourceKey<?>, Entry> f_195913_ = Maps.newIdentityHashMap();

        public <E> void m_206836_(RegistryAccess p_206837_, ResourceKey<E> p_206838_, Encoder<E> p_206839_, int p_206840_, E p_206841_, Lifecycle p_206842_) {
            DataResult dataresult = p_206839_.encodeStart((DynamicOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)p_206837_), p_206841_);
            Optional optional = dataresult.error();
            if (optional.isPresent()) {
                f_195912_.error("Error adding element: {}", (Object)((DataResult.PartialResult)optional.get()).message());
            } else {
                this.f_195913_.put(p_206838_, new Entry((JsonElement)dataresult.result().get(), p_206840_, p_206842_));
            }
        }

        @Override
        public <E> Collection<ResourceKey<E>> m_183590_(ResourceKey<? extends Registry<E>> p_195932_) {
            return this.f_195913_.keySet().stream().flatMap(p_195935_ -> p_195935_.m_195975_(p_195932_).stream()).collect(Collectors.toList());
        }

        @Override
        public <E> Optional<DataResult<ParsedEntry<E>>> m_183313_(DynamicOps<JsonElement> p_195917_, ResourceKey<? extends Registry<E>> p_195918_, ResourceKey<E> p_195919_, Decoder<E> p_195920_) {
            Entry registryresourceaccess$inmemorystorage$entry = this.f_195913_.get(p_195919_);
            if (registryresourceaccess$inmemorystorage$entry != null && registryresourceaccess$inmemorystorage$entry.f_195936_ != null && registryresourceaccess$inmemorystorage$entry.f_195936_.isJsonObject()) {
                registryresourceaccess$inmemorystorage$entry.f_195936_.getAsJsonObject().addProperty("forge:registry_name", p_195919_.m_135782_().toString());
            }
            return registryresourceaccess$inmemorystorage$entry == null ? Optional.of(DataResult.error((String)("Unknown element: " + p_195919_))) : Optional.of(p_195920_.parse(p_195917_, (Object)registryresourceaccess$inmemorystorage$entry.f_195936_).setLifecycle(registryresourceaccess$inmemorystorage$entry.f_195938_).map(p_195930_ -> ParsedEntry.m_195958_(p_195930_, p_195929_.f_195937_)));
        }

        record Entry(JsonElement f_195936_, int f_195937_, Lifecycle f_195938_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "data;id;lifecycle", "f_195936_", "f_195937_", "f_195938_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "data;id;lifecycle", "f_195936_", "f_195937_", "f_195938_"}, this);
            }

            @Override
            public final boolean equals(Object p_195947_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "data;id;lifecycle", "f_195936_", "f_195937_", "f_195938_"}, this, p_195947_);
            }
        }
    }
}

